(defmeth graph-proto :canvas-pos-tick-marks (axis)
  "Args: Axis can be 0 or 1."
  (let* (
         (axis axis)
         (num-ticks (if (= axis 0) 
                       (third (send self :x-axis))
                       (third (send self :y-axis))
                           ))                      
         (min-range (min (send self :range axis)))
         (max-range (max (send self :range axis)))
         (nice-range (get-nice-range min-range max-range num-ticks))
         (diff-ticks (/ (- max-range min-range) (- num-ticks 1)))
         (pos-ticks (cumsum (combine min-range (repeat diff-ticks (- num-ticks 1)))))
         )
    pos-ticks
    ))

(defmeth graph-proto :real-pos-tick-marks (axis)
  "Args: Axis can be 0 or 1."
  (let* ((pos (send self :canvas-pos-tick-marks axis))
         (axis axis)
         )
    (if (= axis 0) (mapcar #'(lambda (posit) 
                               (first (send self :real-to-canvas posit 0)))
                           pos)
        (mapcar #'(lambda (posit) 
                               (second (send self :real-to-canvas 1 posit )))
                           pos))
  
    ))

(defmeth graph-proto :right-ticks ()
  (let* (
         (axis 1)
         (pos-ticks 
          (mapcar #'(lambda (pos)
                     (second (send self :real-to-canvas
                            0
                            pos
                            )))
                  (send self :canvas-pos-tick-marks axis)))
         (right (first (send self :real-to-canvas
                              (second (send self :range '0))
                              0
                              )))
         (length-tick 3)
         )
    (mapcar #'(lambda (pos)
                (send self :draw-line
                      right pos (+ right length-tick) pos
                      ))
            pos-ticks)
    right)
    )


(defmeth graph-proto :right-labels (&optional labels)
  (let* (
         (axis 1)
         (pos-ticks 
          (mapcar #'(lambda (pos)
                     (second (send self :real-to-canvas
                            0
                            pos
                            )))
                  (send self :canvas-pos-tick-marks axis)))
         (right (first (send self :real-to-canvas 
                              (second (send self :range '0))
                              0
                              )))
         (length-tick 3)
         (label-ticks (send self :canvas-pos-tick-marks axis))
         (labels (if labels labels (mapcar #'princ-to-string label-ticks)))
         )
    (mapcar #'(lambda (pos lab)
                (send self :draw-text-up lab
                       (+ right length-tick) pos  1 1
                      ))
            pos-ticks labels)
    labels)
    )
(defmeth graph-proto :exp-right-labels ()
  (let* ((exp (exp (send self :canvas-pos-tick-marks 1)))
         (lab (mapcar #'(lambda (ex) (if (>= ex 1) 
                                         (princ-to-string (round ex))
                                         (format nil "~1,1g" ex)))
                      exp))
         )
                                        
    (send self :right-labels lab)
    ))